package pt.caf_pbs.schooldiskapi.model;

import pt.caf_pbs.schooldiskapi.exceptions.InvalidDataException;

import java.io.Serializable;

public class Instructor extends Person implements Serializable {
    private String initials;
    private LectureContainer lectures;

    public Instructor(String initials, String name) {
        super(name);
        lectures = new LectureContainer();
        setInitials(initials);
    }

    private boolean isInitialsValid(String initials) {
        return initials.length() == 4;
    }

    public String getInitials() {
        return this.initials;
    }

    public void setInitials(String initials) {
        if (isInitialsValid(initials)) {
            this.initials = initials;
        } else {
            String msg = "Instructor: " + initials;
            throw new InvalidDataException(msg);
        }
    }

    public LectureContainer getLectures() {
        return this.lectures;
    }

    public void setLectures(LectureContainer lectures) {
        this.lectures = lectures;
    }

    public boolean isEqualTo(Instructor obj) {
        return this.initials.equals(obj.initials);
    }

    public boolean isEqualTo(String initials) {
        return this.initials.equals(initials);
    }
}
